
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PDV_VD_IT_CONCOR]') AND type in (N'U'))
BEGIN
	
	SET ANSI_NULLS ON

	SET QUOTED_IDENTIFIER ON

	CREATE TABLE [dbo].[PDV_VD_IT_CONCOR](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_IT] [int] NOT NULL,
		[CD_PROD] [int] NOT NULL,
		[CD_VD] [int] NOT NULL,
		[DT_CAD] [datetime] NULL,
		[CD_VEND] [int] NOT NULL,
		[CD_CONCOR] [int] NOT NULL,
		[VLR_CONCOR] [money] NOT NULL,
		[PERC_DESC] [money] NOT NULL,
		
	 CONSTRAINT [PK_PDV_VD_IT_CONCOR] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_IT] ASC,
		[CD_PROD] ASC,
		[CD_VD] ASC
			
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[PDV_VD_IT_CONCOR] ADD  CONSTRAINT [DF_PDV_VD_IT_CONCOR_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[PDV_VD_IT_CONCOR] ADD  CONSTRAINT [DF_PDV_VD_IT_CONCOR_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

	ALTER TABLE [dbo].[PDV_VD_IT_CONCOR] ADD  CONSTRAINT [DF_PDV_VD_IT_CONCOR_CD_IT]  DEFAULT ((0)) FOR [CD_IT]

	ALTER TABLE [dbo].[PDV_VD_IT_CONCOR] ADD  CONSTRAINT [DF_PDV_VD_IT_CONCOR_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

	ALTER TABLE [dbo].[PDV_VD_IT_CONCOR] ADD  CONSTRAINT [DF_PDV_VD_IT_CONCOR_CD_VD]  DEFAULT ((0)) FOR [CD_VD]
	
	ALTER TABLE [dbo].[PDV_VD_IT_CONCOR] ADD  CONSTRAINT [DF_PDV_VD_IT_CONCOR_CD_VEND]  DEFAULT ((0)) FOR [CD_VEND]

	ALTER TABLE [dbo].[PDV_VD_IT_CONCOR] ADD  CONSTRAINT [DF_PDV_VD_IT_CONCOR_CD_CONCOR]  DEFAULT ((0)) FOR [CD_CONCOR]

	ALTER TABLE [dbo].[PDV_VD_IT_CONCOR] ADD  CONSTRAINT [DF_PDV_VD_IT_CONCOR_VLR_CONCOR]  DEFAULT ((0)) FOR [VLR_CONCOR]

	ALTER TABLE [dbo].[PDV_VD_IT_CONCOR] ADD  CONSTRAINT [DF_PDV_VD_IT_CONCOR_PERC_DESC]  DEFAULT ((0)) FOR [PERC_DESC]

END;
